# RoadsRegional_SnagDensity_update.py
# Created on: 2014-06-10 by cbelongie
# Usage: RoadsRegional_SnagDensity_update <Study_Area_Code__4_char_max_> <Output_Workspace_Folder> <Study_Area_Boundary> <sng50_1> <sng25_2> <sng25_1> <s50_rd40cls> <s25_1rd40cls> <s25_2rd40cls> <S_USA_RoadCore_Existing>
# Description:
# This Model will update GNN snag densities to reflect areas adjacent to Roads.  Snag densities within 50 m of a road will be reduced by 40%.
# The regional roads from edw are the default option for this model. If you want to run this model with a different set of roads, use the "LocalRoadSnagDensity" from the Toolbox.
# If you are going to run a distribution analysis and run the Model: Forest_huc_snag, rename the output files to sng50_1, sng25_1, sng25_2 before running that model.
#
# IF YOU update the default snag density datasets (sng50_1, sng25_1, sng25_2) you will need to make new underlying data to run this model - SEE DOCUMENTATION!


import arcpy, os, sys

from arcpy import env
from arcpy.sa import *
arcpy.env.overwriteOutput = True


#get parameters for model
stdyCode =  arcpy.GetParameterAsText(0)

outWksp =  arcpy.GetParameterAsText(1) 

stdyBndry =  arcpy.GetParameterAsText(2) 

sng50_1 =  arcpy.GetParameterAsText(3) 

sng25_2 =  arcpy.GetParameterAsText(4) 

sng25_1 =  arcpy.GetParameterAsText(5) 

s50_rd40cls =  arcpy.GetParameterAsText(6) 

s25_1rd40cls =  arcpy.GetParameterAsText(7) 

s25_2rd40cls =  arcpy.GetParameterAsText(8) 

roadCoreExisting =  arcpy.GetParameterAsText(9) 


arcpy.AddMessage("Output workspace is " + str(outWksp))

outPath = str(outWksp)

tmpDir = os.environ['tmp']
arcpy.CreateFolder_management(tmpDir, 'scratch')
arcpy.CreateFileGDB_management(tmpDir + "\\scratch", "temp.gdb")
arcpy.env.workspace = tmpDir + "\\scratch\\temp.gdb"

scratchWkspc = arcpy.env.workspace

arcpy.AddMessage ("Scratch workspace is " + scratchWkspc)






#roads form edw roads and project r6 roads to output

roadFL = arcpy.MakeFeatureLayer_management (roadCoreExisting, "RoadCoreExisting", "ADMIN_ORG LIKE '06%' OR ADMIN_ORG = '010408'")
arcpy.AddMessage("....selecting r6 roads")
r6Roads = arcpy.CopyFeatures_management(roadFL, scratchWkspc +"\\r6Rds")

arcpy.AddMessage("....projecting roads")
roadsProject = arcpy.Project_management(r6Roads, scratchWkspc + "\\RoadsProject", "PROJCS['NAD_1983_Oregon_Washington_Albers',GEOGCS['GCS_North_American_1983',DATUM['D_North_American_1983',SPHEROID['GRS_1980',6378137.0,298.257222101]],PRIMEM['Greenwich',0.0],UNIT['Degree',0.0174532925199433]],PROJECTION['Albers'],PARAMETER['False_Easting',600000.0],PARAMETER['False_Northing',0.0],PARAMETER['Central_Meridian',-120.0],PARAMETER['Standard_Parallel_1',43.0],PARAMETER['Standard_Parallel_2',48.0],PARAMETER['Latitude_Of_Origin',34.0],UNIT['Meter',1.0]]", "", "GEOGCS['GCS_North_American_1983',DATUM['D_North_American_1983',SPHEROID['GRS_1980',6378137.0,298.257222101]],PRIMEM['Greenwich',0.0],UNIT['Degree',0.0174532925199433]]")

#Euclidean Distance on roads
arcpy.AddMessage ("....running euclidean distance")


arcpy.env.mask = stdyBndry
eucDistTemp = arcpy.gp.EucDistance_sa(roadsProject,scratchWkspc + "\\" +"eucDist","50", "30","") 


#reclassify euc. output
arcpy.AddMessage("....relassifying euclidean dist. output")

outReclass = arcpy.gp.Reclassify_sa(scratchWkspc + "\\" + "eucDist","Value","0 1;0 30 1;30 50 1","eucDist_rcls","NODATA") 

#combine1
arcpy.AddMessage("....running 1 of 3 combines")

s50rd = arcpy.gp.Combine_sa([s50_rd40cls, outReclass], stdyCode + "__s50rd") 

#looup1
arcpy.AddMessage("....running 1 of 3 lookups")

lookup1 = Lookup(s50rd, "s50_rd40cls")
s50rdx = lookup1.save("s50rdx")

#mosaic1
arcpy.AddMessage("....running 1 of 3 mosaics")

arcpy.env.snapRaster = sng50_1 
arcpy.env.extent = stdyBndry 

inputList = [scratchWkspc + "\\s50rdx", sng50_1] 

mosaic1 = arcpy.MosaicToNewRaster_management(inputList,scratchWkspc,stdyCode + "_s50wrd","#","8_BIT_UNSIGNED","30","1","FIRST","FIRST")

#run of the snag desnity model part1
arcpy.AddMessage("....generating new snag density output sn50_rd")

sn50a = arcpy.gp.Combine_sa([r"T:\FS\Reference\GeoTool\r06\Toolbox\DecAID\DecAID_data2012\DecAID_2012Input.gdb\dhtype", r"T:\FS\Reference\GeoTool\r06\Toolbox\DecAID\DecAID_data2012\DecAID_2012Input.gdb\scls_rcls", mosaic1, r"T:\FS\Reference\GeoTool\r06\Toolbox\DecAID\DecAID_data2012\DecAID_2012Input.gdb\r6huc10"], stdyCode + "__sn50a")

sn50a = arcpy.AddField_management(sn50a,"S50cls","LONG","10","#","#","#","NULLABLE","NON_REQUIRED","#")

s50wrdField = stdyCode + "_S50WRD"

sn50a = arcpy.CalculateField_management(sn50a,"S50CLS","[DHTYPE] + [SCLS_RCLS] + [%s]" % (s50wrdField),"VB","#")

sn50a = arcpy.AddField_management(sn50a,"Sn50_AC","LONG","10","#","#","#","NULLABLE","NON_REQUIRED","#")

sn50a = arcpy.CalculateField_management(sn50a,"SN50_AC","([COUNT]*900)/10000*2.471","VB","#")

sn50aLay = arcpy.MakeRasterLayer_management(sn50a,stdyCode + "_sn50aLay")

sn50aLay = arcpy.AddJoin_management(sn50aLay,"S50CLS","T:/FS/Reference/GeoTool/r06/Toolbox/DecAID/DecAID_data2012/LUT_sng50.dbf","LongValue","KEEP_ALL")

sn50aLay = arcpy.CopyRaster_management(sn50aLay,scratchWkspc + "\\" + stdyCode +"_sn50aLAY","#","#","#","NONE","NONE","#","NONE","NONE")

sn50aLay = arcpy.MakeRasterLayer_management(sn50aLay,stdyCode + "_sn50aLay2")

sn50aLay = arcpy.AddJoin_management(sn50aLay,"R6HUC10","T:/FS/Reference/GeoTool/r06/Toolbox/DecAID/DecAID_data2012/LUT_HUC10_New.dbf","VALUE","KEEP_ALL") 

sn50aLay = arcpy.CopyRaster_management(sn50aLay,outPath + "\\" + stdyCode +"_sn50_rd","#","#","#","NONE","NONE","#","NONE","NONE")

sn50aLayView = arcpy.MakeTableView_management(sn50aLay,"test_sn50aLAY_View","#","#","Rowid Rowid HIDDEN NONE;VALUE VALUE HIDDEN NONE;COUNT COUNT HIDDEN NONE;DHTYPE DHTYPE HIDDEN NONE;SCLS_RCLS SCLS_RCLS HIDDEN NONE;s50wrdField s50wrdField VISIBLE NONE;R6HUC10 R6HUC10 HIDDEN NONE;S50CLS S50CLS HIDDEN NONE;SN50_AC SN50_AC VISIBLE NONE;OID_ OID_ HIDDEN NONE;VALUE_1 VALUE_1 HIDDEN NONE;HABTYPE HABTYPE VISIBLE NONE;SZCLS SZCLS VISIBLE NONE;STPH_GE50 STPH_GE50 VISIBLE NONE;HRV_SNG HRV_SNG VISIBLE NONE;LONGVALUE LONGVALUE HIDDEN NONE;OID_1 OID_1 HIDDEN NONE;OBJECTID OBJECTID HIDDEN NONE;VALUE_12 VALUE_12 HIDDEN NONE;HUC_10 HUC_10 VISIBLE NONE;HU_10_NAME HU_10_NAME VISIBLE NONE;HUC10_ACRE HUC10_ACRE VISIBLE NONE")

arcpy.TableSelect_analysis(sn50aLayView,outPath + "\\" + stdyCode +"_sn50_rd.dbf",""""SzCls" <> ''""")


#combine2
arcpy.AddMessage("....running 2 of 3 combines")

s25_1rd = arcpy.gp.Combine_sa([s25_1rd40cls, outReclass], stdyCode + "_s25_1rd") 

# lookup2
arcpy.AddMessage("....running 2 of 3 lookups")

lookup2 = Lookup(s25_1rd, "s25_1rd40cls")
s25_1rx = lookup2.save("s25_1rx")

#mosaic2
arcpy.AddMessage("....running 2 of 3 mosaics")

arcpy.env.snapRaster = sng25_1 
arcpy.env.extent = stdyBndry 

inputList =  [scratchWkspc + "\\s25_1rx", sng25_1] 

mosaic2 = arcpy.MosaicToNewRaster_management(inputList,scratchWkspc,stdyCode + "_s25_1wrd","#","8_BIT_UNSIGNED","30","1","FIRST","FIRST")

#run of the snag desnity model part2
arcpy.AddMessage("....generating new snag density output sn25a_rd")

sn25a = arcpy.gp.Combine_sa([r"T:\FS\Reference\GeoTool\r06\Toolbox\DecAID\DecAID_data2012\DecAID_2012Input.gdb\dhtype", r"T:\FS\Reference\GeoTool\r06\Toolbox\DecAID\DecAID_data2012\DecAID_2012Input.gdb\scls_rcls", mosaic2, r"T:\FS\Reference\GeoTool\r06\Toolbox\DecAID\DecAID_data2012\DecAID_2012Input.gdb\r6huc10"], stdyCode + "__sn25a")

sn25a = arcpy.AddField_management(sn25a,"S25acls","LONG","10","#","#","#","NULLABLE","NON_REQUIRED","#")

s25wrdField = stdyCode + "_S25_1WRD"

sn25a = arcpy.CalculateField_management(sn25a,"S25ACLS","[DHTYPE] + [SCLS_RCLS] + [%s]" % (s25wrdField),"VB","#")

sn25a = arcpy.AddField_management(sn25a,"Sn25a_AC","LONG","10","#","#","#","NULLABLE","NON_REQUIRED","#")

sn25a = arcpy.CalculateField_management(sn25a,"SN25A_AC","([COUNT]*900)/10000*2.471","VB","#")

sn25aLay = arcpy.MakeRasterLayer_management(sn25a,stdyCode + "_sn25aLay")

sn25aLay = arcpy.AddJoin_management(sn25aLay,"S25ACLS","T:/FS/Reference/GeoTool/r06/Toolbox/DecAID/DecAID_data2012/LUT_sng25_1.dbf","LongValue","KEEP_ALL")

sn25aLay = arcpy.CopyRaster_management(sn25aLay,scratchWkspc + "\\" + stdyCode +"_sn25aLAY","#","#","#","NONE","NONE","#","NONE","NONE")

sn25aLay = arcpy.MakeRasterLayer_management(sn25aLay,stdyCode + "_sn25aLay2")

sn25aLay = arcpy.AddJoin_management(sn25aLay,"R6HUC10","T:/FS/Reference/GeoTool/r06/Toolbox/DecAID/DecAID_data2012/LUT_HUC10_New.dbf","VALUE","KEEP_ALL") 

sn25aLay = arcpy.CopyRaster_management(sn25aLay,outPath + "\\" + stdyCode +"_sn25a_rd","#","#","#","NONE","NONE","#","NONE","NONE")

sn25aLayView = arcpy.MakeTableView_management(sn25aLay,"test_sn25aLAY_View","#","#","Rowid Rowid HIDDEN NONE;VALUE VALUE HIDDEN NONE;COUNT COUNT HIDDEN NONE;DHTYPE DHTYPE HIDDEN NONE;SCLS_RCLS SCLS_RCLS HIDDEN NONE;s25wrdField s25wrdField VISIBLE NONE;R6HUC10 R6HUC10 HIDDEN NONE;S25ACLS S25ACLS HIDDEN NONE;SN25A_AC SN25A_AC VISIBLE NONE;OID_ OID_ HIDDEN NONE;VALUE_1 VALUE_1 HIDDEN NONE;HABTYPE HABTYPE VISIBLE NONE;SZCLS SZCLS VISIBLE NONE;STPH_GE25 STPH_GE25 VISIBLE NONE;HRV_SNG HRV_SNG VISIBLE NONE;LONGVALUE LONGVALUE HIDDEN NONE;OID_1 OID_1 HIDDEN NONE;OBJECTID OBJECTID HIDDEN NONE;VALUE_12 VALUE_12 HIDDEN NONE;HUC_10 HUC_10 VISIBLE NONE;HU_10_NAME HU_10_NAME VISIBLE NONE;HUC10_ACRE HUC10_ACRE VISIBLE NONE")

arcpy.TableSelect_analysis(sn25aLayView,outPath + "\\" + stdyCode +"_sn25a_rd.dbf",""""SzCls" <> ''""")

#combine3
arcpy.AddMessage("....running 3 of 3 combines")

s25_2rd = arcpy.gp.Combine_sa([s25_2rd40cls, outReclass], stdyCode + "_s25_2rd") 

# lookup3
arcpy.AddMessage("....running 3 of 3 lookups")

lookup3 = Lookup(s25_2rd, "s25_2rd40cls")
s25_2rx = lookup3.save("s25_2rx")

#mosaic3
arcpy.AddMessage("....running 3 of 3 mosaics")

arcpy.env.snapRaster = sng25_2 
arcpy.env.extent = stdyBndry 

inputList = [scratchWkspc + "\\s25_2rx", sng25_2] 

mosaic3 = arcpy.MosaicToNewRaster_management(inputList,scratchWkspc,stdyCode + "_s25_2wrd","#","8_BIT_UNSIGNED","30","1","FIRST","FIRST")

#run of the snag desnity model part3
arcpy.AddMessage("....generating new snag density output s25b_rd")

sn25b = arcpy.gp.Combine_sa([r"T:\FS\Reference\GeoTool\r06\Toolbox\DecAID\DecAID_data2012\DecAID_2012Input.gdb\dhtype", r"T:\FS\Reference\GeoTool\r06\Toolbox\DecAID\DecAID_data2012\DecAID_2012Input.gdb\scls_rcls", mosaic3, r"T:\FS\Reference\GeoTool\r06\Toolbox\DecAID\DecAID_data2012\DecAID_2012Input.gdb\r6huc10"], stdyCode + "__sn25b")

sn25b = arcpy.AddField_management(sn25b,"S25bcls","LONG","10","#","#","#","NULLABLE","NON_REQUIRED","#")

s25wrdField = stdyCode + "_S25_2WRD"

sn25b = arcpy.CalculateField_management(sn25b,"S25BCLS","[DHTYPE] + [SCLS_RCLS] + [%s]" % (s25wrdField),"VB","#")

sn25b = arcpy.AddField_management(sn25b,"Sn25b_AC","LONG","10","#","#","#","NULLABLE","NON_REQUIRED","#")

sn25b = arcpy.CalculateField_management(sn25b,"SN25B_AC","([COUNT]*900)/10000*2.471","VB","#")

sn25bLay = arcpy.MakeRasterLayer_management(sn25b,stdyCode + "_sn25bLay")

sn25bLay = arcpy.AddJoin_management(sn25bLay,"S25BCLS","T:/FS/Reference/GeoTool/r06/Toolbox/DecAID/DecAID_data2012/LUT_sng25_2.dbf","LongValue","KEEP_ALL")

sn25bLay = arcpy.CopyRaster_management(sn25bLay,scratchWkspc + "\\" + stdyCode +"_sn25bLAY","#","#","#","NONE","NONE","#","NONE","NONE")

sn25bLay = arcpy.MakeRasterLayer_management(sn25bLay,stdyCode + "_sn25bLay2")

sn25bLay = arcpy.AddJoin_management(sn25bLay,"R6HUC10","T:/FS/Reference/GeoTool/r06/Toolbox/DecAID/DecAID_data2012/LUT_HUC10_New.dbf","VALUE","KEEP_ALL") 

sn25bLay = arcpy.CopyRaster_management(sn25bLay,outPath + "\\" + stdyCode +"_sn25b_rd","#","#","#","NONE","NONE","#","NONE","NONE")

sn25bLayView = arcpy.MakeTableView_management(sn25bLay,"test_sn25bLAY_View","#","#","Rowid Rowid HIDDEN NONE;VALUE VALUE HIDDEN NONE;COUNT COUNT HIDDEN NONE;DHTYPE DHTYPE HIDDEN NONE;SCLS_RCLS SCLS_RCLS HIDDEN NONE;s25wrdField s25wrdField VISIBLE NONE;R6HUC10 R6HUC10 HIDDEN NONE;S25BCLS S25BCLS HIDDEN NONE;SN25B_AC SN25B_AC VISIBLE NONE;OID_ OID_ HIDDEN NONE;VALUE_1 VALUE_1 HIDDEN NONE;HABTYPE HABTYPE VISIBLE NONE;SZCLS SZCLS VISIBLE NONE;STPH_GE25 STPH_GE25 VISIBLE NONE;HRV_SNG HRV_SNG VISIBLE NONE;LONGVALUE LONGVALUE HIDDEN NONE;OID_1 OID_1 HIDDEN NONE;OBJECTID OBJECTID HIDDEN NONE;VALUE_12 VALUE_12 HIDDEN NONE;HUC_10 HUC_10 VISIBLE NONE;HU_10_NAME HU_10_NAME VISIBLE NONE;HUC10_ACRE HUC10_ACRE VISIBLE NONE")

arcpy.TableSelect_analysis(sn25bLayView,outPath + "\\" + stdyCode +"_sn25b_rd.dbf",""""SzCls" <> ''""")



