#Script for use to update snag densities from GNN based on recent fire activity and RAVG data from RSAC
#by Cole Belongie cbelongie@fs.fed.us, R6 DRM 12/22/2014

# UPDATED SEPTEMBER 2015 PER DIRECTION FROM JOSH CHAPMAN AND KIM MELLEN-MCLEAN
#MODIFIED RECLASS VALUE OF  1 IN 7 CLASS RAVG TO A 0 OR NO DATA RELCASS VALUE

import arcpy, os, sys

from arcpy import env
from arcpy.sa import *
arcpy.env.overwriteOutput = True

arcpy.CheckOutExtension("Spatial")


#get parameters for model
outWksp = arcpy.GetParameterAsText(0)

RAVG = arcpy.GetParameterAsText(1)

maskArea = arcpy.GetParameterAsText(2) #optional

#checks if optional mask was entered and sets the mask environment accordingly
#if none, then it's a regional replacement run
if maskArea != "":
    arcpy.env.mask = maskArea
else:
    pass

#set GNN Live & Dead in variables
GNNLive = r"T:\FS\Reference\GeoTool\r06\Toolbox\DecAID\DecAID_data2012\DecAID_2012Input.gdb\GNN_Live_ForestClip"
GNNDead = r"T:\FS\Reference\GeoTool\r06\Toolbox\DecAID\DecAID_data2012\DecAID_2012Input.gdb\GNN_Dead_ForestClip"

#set output and scratch workspace
arcpy.AddMessage("Output workspace is " + str(outWksp))

tmpDir = os.environ['tmp']
arcpy.CreateFolder_management(tmpDir, 'scratch')
arcpy.env.workspace = tmpDir + "\\scratch"

scratchWkspc = arcpy.env.workspace

arcpy.AddMessage ("Scratch workspace is " + scratchWkspc)

#############################################################################
#convert 7 class RAVG to 4 class breakdown earlier decided on
inRaster = RAVG
reclassField = "VALUE"
remap = RemapValue([[0,0],[1,0],[2,1],[3,1],[4,2],[5,3],[6,4],[7,4]])

outReclass = Reclassify(inRaster, reclassField, remap, "NODATA")

#increase extent of RAVG for combine
arcpy.AddMessage("....matching extents")
arcpy.env.snapRaster = GNNLive #outReclass
arcpy.env.extent = GNNLive

RAVG_LrgExtnt = SetNull (outReclass, outReclass, "Value = 0")

RAVG_LrgExtnt.save (scratchWkspc + "\\RAVG_lrg")

RAVG_IsNull = IsNull(scratchWkspc + "\\RAVG_lrg")

RAVG_IsNull.save (scratchWkspc + "\\IsNull")

RAVG_rcls = Con (scratchWkspc +"\\IsNull", "0", outReclass, "Value = 1")

RAVG_rcls.save (scratchWkspc + "\\RAVG")


#combine rasters
arcpy.AddMessage("....running combine on datasets")
arcpy.env.snapRaster = GNNLive
if maskArea != "":
    arcpy.env.extent = maskArea
else:
    arcpy.env.extent = GNNLive
    
combine = arcpy.gp.Combine_sa ([GNNLive,RAVG_rcls], scratchWkspc + "\\combine")

#join needed tables
combine_layer = arcpy.MakeRasterLayer_management(combine, "combine_layer")

#NEED TO CHANGE FIELD NAME HERE TO MATCH THE DATA LAYER INPUT NAMES UP TOP IF THEY CHANGE
join = arcpy.JoinField_management(combine_layer, "GNN_Live_ForestC",GNNLive, "Value", ["TPH_25_50", "TPH_GE_50"])
join2 = arcpy.JoinField_management(combine_layer, "GNN_Live_ForestC", GNNDead, "Value", ["STPH_GE_25", "STPH_GE_50"])

#add fields for calculations
joinTable = arcpy.CopyRaster_management(join2, outWksp + "\\RAVG_STPH_Upd")
arcpy.AddField_management(joinTable, "Adj25_50", "DOUBLE", "", "", "", "", "NULLABLE", "", "")
arcpy.AddField_management(joinTable, "Adj_GE50", "DOUBLE", "", "", "", "", "NULLABLE", "", "")
arcpy.AddField_management(joinTable, "N_stph_ge25", "DOUBLE", "", "", "", "", "NULLABLE", "", "")
arcpy.AddField_management(joinTable, "N_stph_ge50", "DOUBLE", "", "", "", "", "NULLABLE", "", "")
arcpy.AddField_management(joinTable, "STPH_25_1", "LONG", "", "", "", "", "NULLABLE", "", "")
arcpy.AddField_management(joinTable, "STPH_25_2", "LONG", "", "", "", "", "NULLABLE", "", "")
arcpy.AddField_management(joinTable, "STPH_50_1", "LONG", "", "", "", "", "NULLABLE", "", "")
arcpy.AddField_management(joinTable, "S25_1Rd40", "DOUBLE", "", "", "", "", "NULLABLE", "", "")
arcpy.AddField_management(joinTable, "S25_2Rd40", "DOUBLE", "", "", "", "", "NULLABLE", "", "")
arcpy.AddField_management(joinTable, "S50_Rd40", "DOUBLE", "", "", "", "", "NULLABLE", "", "")
arcpy.AddField_management(joinTable, "S25_1RD40CLS", "LONG", "", "", "", "", "NULLABLE", "", "")
arcpy.AddField_management(joinTable, "S25_2RD40CLS", "LONG", "", "", "", "", "NULLABLE", "", "")
arcpy.AddField_management(joinTable, "S50_RD40CLS", "LONG", "", "", "", "", "NULLABLE", "", "")


##############################################################################
#set inputRaster and fields list for updates and calculations
inRaster = joinTable
fields = ['RAVG', 'Adj25_50', 'TPH_25_50','Adj_GE50', 'TPH_GE_50', 'N_stph_ge25', 'N_stph_ge50', 'STPH_GE_25', 'STPH_GE_50', 'STPH_25_1','STPH_25_2','STPH_50_1', 'S25_1Rd40', 'S25_2Rd40', 'S50_Rd40', 'S25_1RD40CLS', 'S25_2RD40CLS', 'S50_RD40CLS' ]

#get rid of null values so the addition will work
fieldNamesNull = ['Adj25_50','TPH_25_50','Adj_GE50','TPH_GE_50','STPH_GE_25','STPH_GE_50']

fieldCount = len(fieldNamesNull)

with arcpy.da.UpdateCursor(inRaster, fieldNamesNull) as curU:
    for row in curU:
        rowU = row
        for field in range(fieldCount):
            if rowU[field] == None:
                rowU[field] = 0
        curU.updateRow(rowU)

#adjust tph numbers based on RAVG class
with arcpy.da.UpdateCursor(inRaster, fields) as cursor:
   for row in cursor:
    if row [0] == 0:
        row[1] = 0
        row[3] = 0
    elif row[0] == 1:
        row[1] = (row[2]* 0.2)
        row[3] = (row[4]* 0)
    elif row[0] == 2:
        row[1] = (row[2]* 0.4)
        row[3] = (row[4]* 0.3)
    elif row[0] == 3:
        row[1] = (row[2]* 0.7)
        row[3] = (row[4]* 0.6)
    elif row [0] == 4:
        row[1] = (row[2]* 1)
        row[3] = (row[4]* 0.9)
    cursor.updateRow(row)


#calc fields to get new adjusted stph numbers
with arcpy.da.UpdateCursor(inRaster,fields) as cursor:
    for row in cursor:
        if row[0] == 0:
            row[5] = row[7]
            row[6] = row[8]
        else:
            row[5] = row[7] + row[1] + row[3]
            row[6] = row[8] + row[3]
        cursor.updateRow(row)

#calc S25_1Rd40		
arcpy.CalculateField_management(inRaster, "S25_1Rd40", "[N_stph_ge25]*.4") 
#calc S25_2Rd40		
arcpy.CalculateField_management(inRaster, "S25_2Rd40", "[N_stph_ge25]*.4") 
#calc S50_Rd40		
arcpy.CalculateField_management(inRaster, "S50_Rd40", "[N_stph_ge50]*.4") 

#################################################################################
#reclassify the new stph numbers according to DecAID metadata

#populate stph25_1 field for reclass
with arcpy.da.UpdateCursor(inRaster,fields) as cursor:
    for row in cursor:
        if row[5] == 0:
            row[9] = 1
        elif row[5] > 0 and row[5] < 15:
            row[9] = 14
        elif row[5] >= 15 and row[5] < 30:
            row[9] = 29
        elif row[5] >= 30 and row[5] < 60:
            row[9] = 59
        elif row[5] >= 60 and row[5] < 90:
            row[9] = 89
        elif row[5] >= 90:
            row[9] = 99
        cursor.updateRow(row)

#populate stph25_2 field for reclass
with arcpy.da.UpdateCursor(inRaster,fields) as cursor:
    for row in cursor:
        if row[5] == 0:
            row[10] = 1
        elif row[5] > 0 and row[5] < 10:
            row[10] = 9
        elif row[5] >= 10 and row[5] < 20:
            row[10] = 19
        elif row[5] >= 20 and row[5] < 30:
            row[10] = 29
        elif row[5] >= 30 and row[5] < 60:
            row[10] = 59
        elif row[5] >= 60:
            row[10] = 99
        cursor.updateRow(row)

#populate stph50_1 field for reclass
with arcpy.da.UpdateCursor(inRaster,fields) as cursor:
    for row in cursor:
        if row[6] == 0:
            row[11] = 1
        elif row[6] > 0 and row[6] < 5:
            row[11] = 4
        elif row[6] >= 5 and row[6] < 10:
            row[11] = 9
        elif row[6] >= 10 and row[6] < 15:
            row[11] = 14
        elif row[6] >= 15 and row[6] < 25:
            row[11] = 24
        elif row[6] >= 25 and row[6] < 45:
            row[11] = 44
        elif row[6] >= 45:
            row[11] = 99
        cursor.updateRow(row)

#populate S25_1RD40CLS field for reclass
with arcpy.da.UpdateCursor(inRaster,fields) as cursor:
    for row in cursor:
        if row[12] == 0:
            row[15] = 1
        elif row[12] > 0 and row[12] < 15:
            row[15] = 14
        elif row[12] >= 15 and row[12] < 30:
            row[15] = 29
        elif row[12] >= 30 and row[12] < 60:
            row[15] = 59
        elif row[12] >= 60 and row[12] < 90:
            row[15] = 89
        elif row[12] >= 90:
            row[15] = 99
        cursor.updateRow(row)

#populate S25_2RD40CLS field for reclass
with arcpy.da.UpdateCursor(inRaster,fields) as cursor:
    for row in cursor:
        if row[13] == 0:
            row[16] = 1
        elif row[13] > 0 and row[13] < 10:
            row[16] = 9
        elif row[13] >= 10 and row[13] < 20:
            row[16] = 19
        elif row[13] >= 20 and row[13] < 30:
            row[16] = 29
        elif row[13] >= 30 and row[13] < 60:
            row[16] = 59
        elif row[13] >= 60:
            row[16] = 99
        cursor.updateRow(row)

#populate S50_RD40CLS field for reclass
with arcpy.da.UpdateCursor(inRaster,fields) as cursor:
    for row in cursor:
        if row[14] == 0:
            row[17] = 1
        elif row[14] > 0 and row[14] < 5:
            row[17] = 4
        elif row[14] >= 5 and row[14] < 10:
            row[17] = 9
        elif row[14] >= 10 and row[14] < 15:
            row[17] = 14
        elif row[14] >= 15 and row[14] < 25:
            row[17] = 24
        elif row[14] >= 25 and row[14] < 45:
            row[17] = 44
        elif row[14] >= 45:
            row[17] = 99
        cursor.updateRow(row)
##############################################################################

#run lookup to create new snag input rasters for snag models

lookup25_1 = Lookup(inRaster, "STPH_25_1")
lookup25_1.save(outWksp + "\\sng25_1")

lookup25_2 = Lookup(inRaster, "STPH_25_2")
lookup25_2.save(outWksp + "\\sng25_2")

lookup50_1 = Lookup(inRaster, "STPH_50_1")
lookup50_1.save(outWksp + "\\sng50_1")

lookup25_1rd = Lookup(inRaster, "S25_1RD40CLS")
lookup25_1rd.save(outWksp + "\\s25_1rd40cls")

lookup25_1rd = Lookup(inRaster, "S25_2RD40CLS")
lookup25_1rd.save(outWksp + "\\s25_2rd40cls")

lookup25_1rd = Lookup(inRaster, "S50_RD40CLS")
lookup25_1rd.save(outWksp + "\\s50_rd40cls")

